	TITLE	'XSTAM transmit module vers 1.304'
;
;********************************
;*				*
;*	   BSTAM v4.3		*
;*	    TRANSMIT		*
;*	  LOCAL REV 04		*
;*				*
;********************************
;
; MODIFICATION HISTORY
;=====================
; 
; 10/Jun/82 Added error count to abort after a number
;	  of error messages.
; 06/Aug/81 INCORPORATED K'S FIX TO BUG IN LOCPRT,
;	  MADE CONSOLE ABORT ASSEMBLE SIMPLE
;	  RETURN IF QUIET MODE IS TRUE, BROUGHT
;	  LOCAL REV NUMBER UP TO 3 (R)
; 04/Aug/81 FIXED BUFFER EQUATES	(R)
; 31/Jul/81 ADDED QUIET MODE,CONDITIONALS FOR NOT SENDING
;	  COM FILES, SYS FILES, TAGGED FILES, AND FILES
;	  WITH NAMES ENDING IN "#"	(R)
;
	ORG	0100H
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
QUIET	EQU	TRUE 	;TRUE ASSEMBLES TQ.COM
NOCOMS	EQU	TRUE	;TRUE SUPPRESSES COM FILES
NOTAGS	EQU	TRUE	;TRUE SUPPRESSES TAG2 FILES
NOSYS	EQU	TRUE	;TRUE SUPPRESSES SYS FILES
NOPNDS	EQU	TRUE	;TRUE SUPPRESSES FILES
			;ENDING IN "#"
;
BDOS	EQU	5
DBUF	EQU	80H
DFCB	EQU	5CH
EXT	EQU	0CH
SPEED	EQU	6	;CPU Speed in MHz
MAXDROP	EQU	10	;Maximum number of line dropouts
CARSEC	EQU	5	;Carrier timeout in seconds
MAXERR	EQU	20	;Number of error messages before
			; quiting, reset after each good block
;
CR	EQU	13
LF	EQU	10
;
VDP80	EQU	TRUE	;True for RCPM system
VDATA	EQU	81H
VSTAT	EQU	80H
VMASK	EQU	04H
;
	PAGE
;
; PRINT MACRO FOR MESSAGES
; TO BE SUPPRESSED IN QUIET MODE
;
$-MACRO 		;TURN ON SUPPRESSION
;
PRINT	MACRO	STRING
	LOCAL	OVRSTR,MARK
	JMP	OVRSTR
MARK:	DB	CR,LF,STRING
OVRSTR: LXI	D,MARK
;
	IF	QUIET
	CALL	LOCPRT	;MAYBE PRINT LOCAL ONLY
	ELSE
	MVI	C,9	;NON-QUIET, USE BDOS
	CALL	BDOS
	ENDIF
;
	ENDM
;
; PRINT MACRO FOR MESSAGES ALWAYS PRINTED
;
APRINT	MACRO	STRING
	LOCAL	OVRSTR,MARK
	JMP	OVRSTR
MARK:	DB	CR,LF,STRING
OVRSTR: LXI	D,MARK
	MVI	C,9
	CALL	BDOS
	ENDM
;
;
	PAGE
;
; USER AREA
; NOTE: THE USER AREA SHOULD BE SILENT
; WHEN ASSEMBLED FOR TQ.COM
;
;
USER	EQU	$	;DEFINE USER AREA
;
	JMP	ENTRY
;****************************************************************
;*								*
;*	   XSTAM Interface routines for 2651 UART.		*
;*		on Godbout System Support 1 Board		*
;*								*
;****************************************************************
; 
;************************************************
;*						*
;*	     2651 Baud Rate Table		*
;*						*
;************************************************
;
B50	EQU	0000B			;50 bps
B75	EQU	0001B			;75 bps
B110	EQU	0010B			;110 bps
B134	EQU	0011B			;134.5 bps
B150	EQU	0100B			;150 bps
B300	EQU	0101B			;300 bps
B600	EQU	0110B			;600 bps
B1200	EQU	0111B			;1200 bps
B1800	EQU	1000B			;1800 bps
B2000	EQU	1001B			;2000 bps
B2400	EQU	1010B			;2400 bps
B3600	EQU	1011B			;3600 bps
B4800	EQU	1100B			;4800 bps
B7200	EQU	1101B			;7200 bps
B9600	EQU	1110B			;9600 bps
B19200	EQU	1111B			;19200 bps
;
;************************************************
;*						*
;*		2651 Equates			*
;*						*
;************************************************
;
BASE	EQU	5CH			;UART base register
DATA	EQU	BASE+0			;Data port
MSTATUS	EQU	BASE+1			;Status port
MODE	EQU	BASE+2			;Mode register
CMMD	EQU	BASE+3			;Command register
USERP	EQU	BASE+7			;User select port
UNUM	EQU	6			;Modem user number
MODE1	EQU	01101110B		;Asynch,16x,8 data bits,
					; no parity, even, 1 stop bit
MODE2	EQU	01110000B + B300	;Baud rate
CMMDB	EQU	00100111B		;Tx enabled, RX enabled, no break
					; DTR high, RTS high
ERESET	EQU	CMMDB+10H		;Error reset
GBDTR	EQU	10000000B		;CCITT 108
GBCD	EQU	01000000B		;Carrier detect
;
SYSSPT	EQU	TRUE			;True for Godbout system support
INTER3	EQU	NOT SYSSPT		;True for Godbout Interfacer 3
;
UINITV:
	JMP	INITIU		;UART/USART INITIALATION ENTRY POINT
MSTSV:
	JMP	INSPRU		;STATUS PORT READ ENTRY POINT
ERRSET:
	JMP	ERRSTU		;UART/USART ERROR RESET ENTRY POINT
INPORT:
	JMP	INPRTU		;READ DATA PORT ENTRY POINT
OUTPORT:
	JMP	OUTPRU		;WRITE DATA PORT ENTRY POINT
;
; NEW VECTOR FOR LOCAL CONSOLE
; OUTPUT: PRINT CHAR IN C, CAN
; MODIFY ANY REGISTERS
;
LCOV:	JMP	LCO
;
INITIU:
	CALL	SIGNON		;Announce version

	if	inter3
	MVI	A,UNUM
	OUT	USERP		;Select UART
	endif	;inter3

	MVI	A,MODE1		;Get first mode word
	OUT	MODE
	MVI	A,MODE2		;Get second mode word
	OUT	MODE
	MVI	A,CMMDB		;Get command byte
	OUT	CMMD
	RET			;Retuen to XSTAM
;
INSPRU:
RDMSTS:

	if	inter3
	MVI	A,UNUM
	OUT	USERP		;Select UART
	endif	;inter3

	IN	MSTATUS		;GET MODEM STATUS
	ANI	GBCD		;GOT A CARRIER?
	JNZ	CARROK		;YES, GO ON WITH TESTS
	LDA	DROPOUT		;Get dropout count
	ADI	1		;Increment it
	CPI	MAXDROP		;Bad line?
	JZ	NOCAR		;Yes, reset system
	STA	DROPOUT		;Save for later
	PUSH	B		;PRESERVE BC SO WE CAN USE IT
	MVI	B,CARSEC*10	;SETUP TIMEOUT
CARLP:
	CALL	DELAY		;WAIT .1 SECONDS
	IN	MSTATUS		;GET MODEM STATUS
	ANI	GBCD		;HAS CARRIER RETURNED?
	MOV	A,B		;PRESERVE COUNTDOWN VALUE
	POP	B		;FIX STACK IN CASE ALL IS OK
	JNZ	CARROK		;GOT CARRIER, CONTINUE ON
	DCR	A		;COUNT TIME DOWN
	STC			;IN CASE THIS IS THE END OF TIME
	PUSH	B		;PRESERVE B
	MOV	B,A		;GET COUNTER VALUE IN B
	JNZ	CARLP		;KEEP CHECKING
	POP	B
NOCAR:
	LXI	D,LOST		;Sending anything to conosle
	MVI	C,9		; will let BYE grab control if
	CALL	5		; carrier lost totally else
	JMP	0		; back to CP/M if dropout max
				; was reached.
;
LOST:
	DB	CR,LF,'    ++CARRIER LOST++'
	DB	CR,LF,'The modem is now '
	DB	'DISCONNECTED',CR,LF,'$'
;
CARROK:
	if	inter3
	MVI	A,UNUM
	OUT	USERP		;Select UART
	endif	;inter3

	IN	MSTATUS		;Get status
	ORI	4		;Force Tx empty high
	RET
;
DELAY:
	PUSH	B		;Delay 0.1 second
	LXI	B,SPEED*4167 	;TIMING CONSTANT
DELAY1:
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY1
	POP	B
	RET
;
ERRSTU:
	if	inter3
	MVI	A,UNUM
	OUT	USERP		;Select UART
	endif	;inter3

	MVI	A,ERESET	;Reset error flags in 2651
	OUT	CMMD
	MVI	A,CMMDB		;Restore normal operation
	OUT	CMMD
	RET
;
INPRTU:
	if	inter3
	MVI	A,UNUM
	OUT	USERP		;Select UART
	endif	;inter3

	IN	DATA		;Get data
	RET
;
OUTPRU:
	if	inter3
	PUSH	PSW
	MVI	A,UNUM
	OUT	USERP		;Select UART
	POP	PSW
	endif	;inter3

	OUT	DATA		;Send data
	RET
;
;
SIGNON:
	PUSH	B		;Save  the environment
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9		;BDOS display string command
	CALL	BDOS		;Announce version to user
	POP	H		;Restore the enviroment
	POP	D
	POP	B
	RET
;
hexnum	macro	num
	if	(num/16) > 9 	
	db	(num/16 and 0fh) + 'A' - 10
	else
	db	(num/16 and 0fh) + '0'
	endif
	if	(num and 0fh) > 9
	db	(num and 0fh) + 'A' - 10
	else
	db	(num and 0fh) + '0'
	endif
	endm

MESSGE:
	if	not quiet
	DB	CR,LF,LF
	DB	'Version 1.304, March 29, 1982 by Software Tools',CR,LF
	DB	'2651 UART on '

	if	sysspt
	DB	'Godbout System Support 1 Board'
	endif	;sysspt

	if	inter3
	DB	'Godbout Interfacer 3 Board'
	endif	;sysspt

	DB	CR,LF
	DB	'UART Addressed at ' 
	hexnum	%BASE
	DB	'H, 300 bps, no parity.',CR,LF

	if	inter3
	DB	'UART Relative User '
	hexnum	%UNUM
	DB	',',CR,LF
	endif	;inter3
	endif	;not quite

	DB	'$'
;
; NEW HANDLER FOR LOCAL-CONSOLE
; ONLY.  PRINT REG C, CAN USE
; ANY REGISTER
;
LCO:
	if	vdp80
	IN	VSTAT
	ANI	VMASK
	JZ	LCO
	MOV	A,C
	OUT	VDATA
	else
	LHLD	1
	LXI	D,9	;Offset to COUT
	DAD	D
	PCHL
	endif	;vdp80

	RET		;NULL FOR NOW
;
; END OF USER AREA
;
	PAGE
	ORG	USER+300	;ALLOW 300 BYTES USER AREA
;
; BSTAM INITIAL ENTRY POINT
;
ENTRY:
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	JMP	BYSTAK
;
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	JMP	BYSTAK
;
STACK:	DW	0
;
BYSTAK:
	APRINT	'XSTAM rev 1.304$'
	APRINT	'Transmit Ready$'
	APRINT	'$'
;
PASTMS:
	LDA	DBUF
	CPI	0
	JNZ	GOTFIL
	APRINT	'**** NO FILE NAME - PROGRAM ABORTING ****$'
	JMP	EXIT
;
GOTFIL:
	JMP	START
;
BLDMAP:
	SHLD	NAMSTO
	LXI	H,DBUF
	MVI	C,11H
	LXI	D,DFCB
	LDAX	D
	STA	SDRIVE
	JMP	SRCH2
;
SRCHLP:
	LXI	H,DBUF
	MVI	C,12H
	LXI	D,DFCB
SRCH2:
	CALL	5
	LXI	H,DBUF
	CPI	0FFH
	RZ
	ANI	3
	RLC
	RLC
	RLC
	RLC
	RLC
	ADD	L
	MOV	L,A
;
	IF	NOTAGS	;CODE TO SKIP TAGGED FILES
	INX	H
	INX	H	;POINT TO F2 BYTE
	MOV	A,M	;LOAD IT
	DCX	H	;POINT BACK
	DCX	H
	ORA	A	;SET FLAGS ON A
	JM	SRCHLP	;AND SKIP IF ATR SET
	ENDIF		;NOTAGS
;
	IF	NOSYS	;CODE TO SKIP SYS FILES
	XCHG		;PUT NAME PTR IN DE
	LXI	H,10	;OFFSET TO T2 BYTE
	DAD	D
	MOV	A,M	;PICK UP T2
	XCHG		;RESTORE POINTER
	ORA	A	;SET FLAGS ON A
	JM	SRCHLP	;SKIP IF SYS ATR SET
	ENDIF		;NOSYS
;
	IF	NOPNDS	;CODE TO SKIP "#" FILES
	XCHG		;MOVE PTR TO DE
	LXI	H,11	;OFFSET TO LAST FT CHAR
	DAD	D
	MOV	A,M	;LOAD IT
	ANI	7FH	;KILL ANY ATR BIT
	XCHG		;RESTORE POINTER
	CPI	'#'	;GOT A # FILE?
	JZ	SRCHLP	;SKIP IT IF SO
	ENDIF		;NOPNDS
;
	IF	NOCOMS	;CODE TO SKIP COM FILES
	XCHG		;MOVE POINTER TO DE
	LXI	H,9	;OFFSET TO FIRST FT CHAR
	DAD	D
	MOV	A,M	;PICK UP FIRST
	ANI	7FH	;KILL ATR BIT
	CPI	'C'	;CHAR 1 OF 'COM'
	JNZ	FILOK	;JMP, NOT COM
	INX	H	;GOT C, CHECK FOR 'O'
	MOV	A,M	;PICK UP 2ND FILETYPE CHAR
	ANI	7FH	;KILL ATTRIBUTE
	CPI	'O'
	JNZ	FILOK	;NO COM, FILE OK TO SEND
	INX	H	;GOT 'CO', CHECK FOR 'M'
	MOV	A,M
	ANI	7FH	;STRIP ATR
	CPI	'M'	;NOW...HAVE WE GOT 'COM'?
	JZ	SRCHLP	;SKIP IF SO
FILOK:
	XCHG		;NOPE, RESTORE NAME PTR
	ENDIF		;NOCOMS
;
	LDA	SDRIVE
	MOV	M,A
	CALL	MOVNAM
	JMP	SRCHLP
MOVNAM:
	MVI	B,12
	XCHG
	LHLD	NAMSTO
	XCHG
MOVLP:
	MOV	A,M
	ANI	7FH	;KILL ANY ATTRIBUTES
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVLP
	XCHG
	SHLD	NAMSTO
	RET
;
SDRIVE: DB	0
NAMSTO: DW	0
;
START:
	LXI	H,BUFFER
	CALL	BLDMAP
	LXI	H,BUFFER
	SHLD	NAMPTR
MORCHK:
	MVI	A,0
	STA	FILFLG
	CALL	INI
	LDA	FILFLG
	CPI	1
	JZ	NOMORE
MAIN:
	LDA	FILFLG
	SUI	0
	JNZ	NOMORE
	CALL	SNDFIL
	JMP	MAIN
;
NOMORE:
	CALL	CLNUP
EXIT:
	LDA	FILFLG
	SUI	2
	JZ	MORCHK
	LHLD	STACK
	SPHL
	RET
;
; LOCAL PRINT SUBROUTINE...EMULATES BDOS
; FUNCTION 9 ON LOCAL CONSOLE WHEN 'QUIET'
; CONDITIONAL TRUE...USES LOCAL CO VECTOR
; IN USER AREA (WHICH CAN SIMPLY DO RET
; TO BE TRULY QUIET).
;
	IF	QUIET
LOCPRT:
	LDAX	D	;PICK UP CHAR
	INX	D	;POINT PAST IT
	CPI	'$'	;GOT TERMINATOR?
	RZ		;WE'RE DONE IF SO
	MOV	C,A	;NOT TERM, OUTPUT IT
	PUSH	D	;SAVE STRING PTR
	CALL	LCOV	;SEND IT
	POP	D	;GET STR PTR BACK
	JMP	LOCPRT	;PRINT REST OF STRING
	ENDIF		;QUIET
;
INI:
	MVI	A,0
	STA	L12A9
	STA	L1522
	STA	FILFLG
	STA	ERRCNT	;Reset error count
	STA	L12B7
	STA	ERRHIT	;Reset error count
	MVI	A,1
	STA	L1510
	CALL	UINITV
	PRINT	'**** CONNECTING TO REMOTE CPU ****$'
	JMP	L079A
;
L050E:
	SHLD	L0781
	SHLD	L0785
	XCHG
	SHLD	L0789
	MOV	H,B
	MOV	L,C
	SHLD	L0787
	STA	L078B
	MVI	A,0
	LHLD	L0789
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	DCX	H
	MVI	A,0FFH
	MOV	M,A
	DCX	H
	MVI	A,0
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
	MVI	A,1
	STA	L0784
	STA	L0783
	CALL	ERRSET		;Reset UART errors
L0545:
	LDA	L0784
	SUI	1
	JNZ	L0780
	LHLD	L0787
	MOV	A,M
	LHLD	L0789
	INX	H
	INX	H
	INX	H
	CMP	M
	JNZ	L0697
	MVI	A,0
	STA	L0784
	JMP	L05DB
MODOUT:
	STA	L05DA
	SHLD	L05D5
	XCHG
	SHLD	L05D7
MODLP:
	CALL	MSTSV
	STA	STATUS
	ANI	1
	JZ	MODLP
	LDA	STATUS
	ANI	4
	JZ	MODLP
	LHLD	L05D7
	MOV	A,M
	CALL	OUTPORT
L0587:
	CALL	MSTSV
	ANI	4
	JZ	L0587
	LDA	L05DA
	CPI	1
	RNZ
	LHLD	L05D5
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M
	LHLD	L05D7
	MOV	A,M
	XCHG
	JMP	L05C6
;
CRCADD:
	XRA	H
	MOV	B,A
	RLC
	RLC
	RLC
	RLC
	XRA	B
	MOV	C,A
	ANI	0F0H
	MOV	D,A
	ADD	C
	MOV	E,A
	MOV	A,D
	ACI	0
	XRA	L
	MOV	H,A
	MOV	A,B
	ANI	0F0H
	MOV	B,A
	XRA	E
	MOV	L,A
	MOV	A,B
	RRC
	RRC
	RRC
	XRA	H
	MOV	H,A
	RET
;
L05C6:
	CALL	CRCADD
	XCHG
	LHLD	L05D5
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E
	RET
;
L05D5:	DW	0
L05D7:	DW	0
STATUS: DB	0
L05DA:	DB	0
;
L05DB:
	LHLD	L0789
	XCHG
	LHLD	L078F
	XCHG
	MVI	A,1
	CALL	MODOUT
	CALL	MSTSV
	ANI	2
	JZ	L05FA
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L077D
;
L05FA:
	LDA	L078B
	CPI	1
	JZ	L0612
	LHLD	L0789
	XCHG
	LHLD	L0792
	XCHG
	MVI	A,1
	CALL	MODOUT
	JMP	L063E
;
L0612:
	LHLD	NAMPTR
	INX	H
	MOV	A,M
	CPI	0
	JZ	NONAMS
	MVI	A,2
	STA	FILFLG
	LHLD	L0789
	XCHG
	LHLD	L078C
	XCHG
	MVI	A,1
	CALL	MODOUT
	JMP	L063E
;
NONAMS:
	LHLD	L0789
	XCHG
	LHLD	L0795
	XCHG
	MVI	A,1
	CALL	MODOUT
L063E:
	CALL	MSTSV
	ANI	2
	JZ	L0650
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L077D
;
L0650:
	LHLD	L0789
	INX	H
	INX	H
	SHLD	L0798
	LHLD	L0789
	XCHG
	LHLD	L0798
	XCHG
	MVI	A,0
	CALL	MODOUT
	CALL	MSTSV
	ANI	2
	JNZ	L068D
	LHLD	L0789
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	SHLD	L0798
	LHLD	L0789
	XCHG
	LHLD	L0798
	XCHG
	MVI	A,0
	CALL	MODOUT
	CALL	MSTSV
	ANI	2
	JZ	L077D
L068D:
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L077D
;
L0697:
	CALL	MSTSV
	ANI	2
	JZ	L06AE
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0784
	JMP	L077D
;
L06AE:
	LDA	L0783
	SUI	1
	JNZ	L071E
	LHLD	L0789
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0789
	XCHG
	LHLD	L0785
	XCHG
	MVI	A,1
	CALL	MODOUT
	LHLD	L0785
	INX	H
	SHLD	L0785
	CALL	MSTSV
	ANI	2
	JZ	L06EA
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0784
	JMP	L077D
;
L06EA:
	LHLD	L0789
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0789
	XCHG
	LHLD	L0785
	XCHG
	MVI	A,1
	CALL	MODOUT
	LHLD	L0785
	INX	H
	SHLD	L0785
	DCX	H
	MVI	A,2
	CMP	M
	JNZ	L0716
	MVI	A,0
	STA	L0783
	JMP	L077D
;
L0716:
	MVI	A,0
	STA	L0784
	JMP	L077D
;
L071E:
	LHLD	L0789
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0789
	XCHG
	LHLD	L0785
	XCHG
	MVI	A,1
	CALL	MODOUT
	LHLD	L0785
	INX	H
	SHLD	L0785
	CALL	MSTSV
	ANI	2
	JZ	L0752
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0784
	JMP	L077D
;
L0752:
	LHLD	L0785
	DCX	H
	MVI	A,10H
	CMP	M
	JNZ	L077D
	LHLD	L0789
	XCHG
	LHLD	L078F
	XCHG
	MVI	A,1
	CALL	MODOUT
	CALL	MSTSV
	ANI	2
	JZ	L077D
	LHLD	L0789
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0784
L077D:
	JMP	L0545
;
L0780:
	RET
;
L0781:	DW	0
L0783:	DB	0
L0784:	DB	0
L0785:	DW	0
L0787:	DW	0
L0789:	DW	0
L078B:	DB	0
L078C:	DW	L078E
L078E:	DB	1BH
L078F:	DW	L0791
L0791:	DB	10H
L0792:	DW	L0794
L0794:	DB	3
L0795:	DW	L0797
L0797:	DB	17H
L0798:	DW	0
;
L079A:
	LXI	H,L1511
	LXI	D,STSTOR
	LXI	B,L12B4
	MVI	A,0
	CALL	L050E
L07A8:
	LDA	L1510
	SUI	1
	JNZ	L0CC8
	LDA	STSTOR
	CPI	0
	JZ	L0989
	JMP	ERRORS
;
ERRCHK:
	SHLD	STSPTR
	MVI	A,80H
	ANA	M
	JZ	PARCHK
	PRINT	'**** FRAMING ERROR ****$'
PARCHK:
	LHLD	STSPTR
	MVI	A,40H
	ANA	M
	JZ	OVRCHK
	PRINT	'**** PARITY ERROR ****$'
OVRCHK:
	LHLD	STSPTR
	MVI	A,20H
	ANA	M
	JZ	BCCHCK
	PRINT	'**** OVERRUN ERROR ****$'
BCCHCK:
	LHLD	STSPTR
	MVI	A,10H
	ANA	M
	JZ	LOSCHK
	PRINT	'**** BCC ERROR ****$'
LOSCHK:
	LHLD	STSPTR
	MVI	A,8
	ANA	M
	JZ	TIMCHK
	PRINT	'**** LOST DATA ERROR ****$'
TIMCHK:
	LHLD	STSPTR
	MVI	A,4
	ANA	M
	JZ	EXCHEK
	PRINT	'**** TIME OUT ERROR ****$'
EXCHEK:
	LHLD	STSPTR
	MVI	A,2
	ANA	M
	JZ	LENCHK
	PRINT	'**** EXCEPTION ERROR ****$'
LENCHK:
	LHLD	STSPTR
	MVI	A,1
	ANA	M
	JZ	HITS
	PRINT	'**** LENGTH ERROR ****$'
;
HITS:
	LDA	ERRHIT
	INR	A
	STA	ERRHIT
	CPI	MAXERR
	RNZ
	PRINT	'**** ABORTED, TOO MANY ERRORS ****$'
	XRA	A
	STA	L12A8
	JMP	EXIT
;
STSPTR: DW	0
;
ERRORS:
	LXI	H,STSTOR
	CALL	ERRCHK
	JMP	L0986
;
STOPCK: 
	MVI	C,11
	CALL	5
	ORA	A	;Character at console?
	RZ		;No
	MVI	C,1	;Yes
	CALL	5
	CPI	3	;Abort (control-c)?
	RNZ		;No
	PRINT	'**** ABORTED BY USER ****$'
	XRA	A
	STA	L12A8
	JMP	EXIT
;
L0986:
	CALL	STOPCK
L0989:
	JMP	L0C38
;
L098C:
	SHLD	L0C33
	XCHG
	SHLD	L0C36
	STA	L0C35
	LHLD	L0C33
	SHLD	L0C31
	MVI	A,1
	STA	L0C2C
	STA	L0C2D
	STA	L0C2F
	MVI	A,0
	STA	L0C2E
	LHLD	L0C36
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
	INX	H
	MVI	A,0
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
L09C0:
	LDA	L0C2F
	SUI	1
	JNZ	L0C2B
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	LDA	L0C35
	CMP	M
	JNZ	L0A0A
	MVI	A,0
	STA	L0C2F
	LHLD	L0C31
	DCX	H
	DCX	H
	MOV	A,M
	CPI	10H
	JNZ	L0A00
	INX	H
	MOV	A,M
	CPI	6
	JZ	L0C28
	CPI	15H
	JZ	L0C28
	CPI	5
	JZ	L0C28
	CPI	3
	JZ	L0C28
	CPI	17H
	JZ	L0C28
L0A00:
	LHLD	L0C36
	MVI	A,1
	ORA	M
	MOV	M,A
	JMP	L0C28
;
L0A0A:
	LHLD	L0C36
	MVI	A,0
	MOV	M,A
	JMP	L0AAF
;
GFMODM:
	SHLD	HLSAVE
	STA	ASAVE
	LHLD	L0AAB
	SHLD	L0AA9
L0A1F:
	CALL	MSTSV
	STA	L0AAE
	LDA	L0AAE
	ANI	10H
	JZ	L0A38
	CALL	ERRSET
	LHLD	HLSAVE
	MVI	A,20H
	ORA	M
	MOV	M,A
	RET
;
L0A38:
	LDA	L0AAE
	ANI	8
	JZ	L0A4B
	CALL	ERRSET
	LHLD	HLSAVE
	MVI	A,40H
	ORA	M
	MOV	M,A
	RET
;
L0A4B:
	LDA	L0AAE
	ANI	2
	JZ	L0A85
	CALL	INPORT
	STA	L0AAE
	LDA	ASAVE
	CPI	1
	JZ	L0A65
	LDA	L0AAE
	RET
;
L0A65:
	LHLD	HLSAVE
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M
	LDA	L0AAE
	XCHG
	CALL	CRCADD
	XCHG
	LHLD	HLSAVE
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E
	LDA	L0AAE
	RET
;
L0A85:
	LHLD	L0AA9
	DCX	H
	MVI	A,0
	CMP	H
	JZ	L0A95
	SHLD	L0AA9
	JMP	L0A1F
;
L0A95:
	CMP	L
	JZ	L0A9F
	SHLD	L0AA9
	JMP	L0A1F
;
L0A9F:
	LHLD	HLSAVE
	MVI	A,4
	ORA	M
	MOV	M,A
	RET
;
HLSAVE: DW	0
L0AA9:	DW	0
L0AAB:	DW	0
ASAVE:	DB	0
L0AAE:	DB	0
;
L0AAF:
	LHLD	L0C36
	MVI	A,1
	CALL	GFMODM
	STA	L0C30
	LHLD	L0C36
	MVI	A,0
	CMP	M
	JZ	L0ACB
	MVI	A,0
	STA	L0C2F
	JMP	L0C28
;
L0ACB:
	LDA	L0C2C
	SUI	1
	JNZ	L0B43
	LDA	L0C2D
	SUI	1
	JNZ	L0AFB
	LDA	L0C30
	CPI	10H
	JNZ	L0AEB
	MVI	A,0
	STA	L0C2D
	JMP	L0B2A
L0AEB:
	LHLD	L0C36
	MVI	A,8
	ORA	M
	XCHG
	STAX	D
	MVI	A,0
	STA	L0C2F
	JMP	L0B2A
;
L0AFB:
	LDA	L0C30
	CPI	2
	JNZ	L0B0B
	MVI	A,0
	STA	L0C2C
	JMP	L0B2A
;
L0B0B:
	LDA	L0C30
	CPI	6
	JZ	L0B25
	CPI	15H
	JZ	L0B25
	CPI	5
	JZ	L0B25
	MVI	A,8
	LHLD	L0C36
	ORA	M
	XCHG
	STAX	D
L0B25:
	MVI	A,0
	STA	L0C2F
L0B2A:
	LDA	L0C30
	LHLD	L0C31
	XCHG
	STAX	D
	INX	D
	XCHG
	SHLD	L0C31
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0C28
;
L0B43:
	LDA	L0C2E
	SUI	1
	JNZ	L0C07
	LDA	L0C30
	CPI	10H
	JNZ	L0B6F
	MVI	A,0
	STA	L0C2E
	LDA	L0C30
	LHLD	L0C31
	MOV	M,A
	INX	H
	SHLD	L0C31
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0C28
;
L0B6F:
	LDA	L0C30
	CPI	17H
	JZ	L0B9F
	CPI	3
	JZ	L0B9F
	CPI	1BH
	JZ	L0B9F
	LHLD	L0C36
	MVI	A,8
	ORA	M
	MOV	M,A
	LDA	L0C30
	LHLD	L0C31
	MOV	M,A
	INX	H
	SHLD	L0C31
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0BFF
;
L0B9F:
	MVI	A,10H
	LHLD	L0C31
	MOV	M,A
	INX	H
	LDA	L0C30
	MOV	M,A
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	INR	A
	MOV	M,A
	LHLD	L0C36
	MVI	A,0
	CALL	GFMODM
	STA	L0C30
	LHLD	L0C36
	MVI	A,0
	CMP	M
	JNZ	L0BFF
	INX	H
	LDA	L0C30
	MOV	M,A
	LHLD	L0C36
	MVI	A,0
	CALL	GFMODM
	STA	L0C30
	LHLD	L0C36
	MVI	A,0
	CMP	M
	JNZ	L0BFF
	INX	H
	INX	H
	INX	H
	INX	H
	LDA	L0C30
	MOV	M,A
	INX	H
	CMP	M
	JNZ	L0BF8
	LHLD	L0C36
	INX	H
	MOV	A,M
	INX	H
	CMP	M
	JZ	L0BFF
L0BF8:
	MVI	A,10H
	LHLD	L0C36
	ORA	M
	MOV	M,A
L0BFF:
	MVI	A,0
	STA	L0C2F
	JMP	L0C28
;
L0C07:
	LDA	L0C30
	CPI	10H
	JNZ	L0C17
	MVI	A,1
	STA	L0C2E
	JMP	L0C28
;
L0C17:
	LHLD	L0C31
	MOV	M,A
	INX	H
	SHLD	L0C31
	LHLD	L0C36
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
L0C28:
	JMP	L09C0
L0C2B:
	RET
;
L0C2C:	DB	0
L0C2D:	DB	0
L0C2E:	DB	0
L0C2F:	DB	0
L0C30:	DB	0
L0C31:	DW	0
L0C33:	DW	0
L0C35:	DB	0
L0C36:	DW	0
;
L0C38:
	LXI	H,L1380
	LXI	D,L1519
	MVI	A,2
	CALL	L098C
	LDA	L1519
	CPI	0
	JZ	L0C65
	LXI	H,L1519
	CALL	ERRCHK
	CALL	STOPCK
	LXI	H,L1511
	LXI	D,STSTOR
	LXI	B,L12B4
	MVI	A,0
	CALL	L050E
	JMP	L0CC5
;
L0C65:
	LDA	L1380
	CPI	10H
	JNZ	L0C7D
	LDA	SYNCB
	CPI	6
	JNZ	L0C7D
	MVI	A,0
	STA	L1510
	JMP	L0CC5
L0C7D:
	PRINT	'**** CONNECTION IS STILL IN PROGRESS ****$'
	CALL	STOPCK
	LXI	H,L1511
	LXI	D,STSTOR
	LXI	B,L12B4
	MVI	A,0
	CALL	L050E
L0CC5:
	JMP	L07A8
;
L0CC8:
	XRA	A
	STA	ERRHIT	;Reset error count
	PRINT	'**** REMOTE CPU IS NOW CONNECTED ****$'
	RET
;
SNDFIL:
	MVI	A,1
	STA	L151F
	STA	L1520
	MVI	A,0
	STA	ERRCNT
	STA	ERRSFL
	LDA	L1522
	SUI	1
	JZ	OPENOK
	LHLD	NAMPTR
	LXI	D,DFCB
	MVI	C,0CH
MV1:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MV1
	LXI	D,L12B8
	LHLD	NAMPTR
	INX	H
	MVI	C,0BH
MV2:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MV2
	SHLD	NAMPTR
	MVI	A,1
	STA	L1522
	MVI	B,8
	LXI	H,DFCB+1
	LXI	D,FILNAM
MV3:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MV3
	INX	D
	MVI	B,3
MV4:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MV4
FILNAM	EQU	$+24+3
	PRINT	'---- TRANSMITING FILE --------.--- ----$'
	JMP	BLDFCB
;
MOVE:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MOVE
	RET
;
BLDFCB:
	LXI	H,DFCB
	LXI	D,MYFCB
	MVI	C,0CH
	CALL	MOVE
	JMP	PSTFCB
;
MYFCB:	DB	'****$',0EH,9,11H,80H,0CH
	DB	0CDH,5
	DB	0,0CDH,'4',9,'!',11H,15H,11H
	DB	13H,15H,1,0B4H,12H,'>',0,0CDH
	DB	0EH,5,0C3H,0A8H
FILREC: DB	7
FILBAS: DW	L1B25
BUFLEN: DW	L1380
BUFPTR: DW	L2A0A
;
PSTFCB:
	JMP	OPNFCB
;
RDFILE:
	LHLD	BUFLEN
	XCHG
	LHLD	BUFPTR
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	NOREAD
	LXI	H,0
	SHLD	BUFPTR
RDLOOP:
	XCHG
	LHLD	BUFLEN
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	L0E19
	LHLD	FILBAS
	DAD	D
	XCHG
	MVI	C,1AH
	CALL	5
	LXI	D,MYFCB
	MVI	C,14H
	CALL	5
	ORA	A
	JNZ	BADRD
	LXI	D,DBUF
	LHLD	BUFPTR
	DAD	D
	SHLD	BUFPTR
	JMP	RDLOOP
;
BADRD:
	LHLD	BUFPTR
	SHLD	BUFLEN
L0E19:
	LXI	D,DBUF
	MVI	C,1AH
	CALL	5
	LXI	H,0
	SHLD	BUFPTR
NOREAD:
	XCHG
	LHLD	FILBAS
	DAD	D
	XCHG
	LHLD	BUFLEN
	MOV	A,L
	ORA	H
	MVI	A,1AH
	RZ
	LDAX	D
	LHLD	BUFPTR
	INX	H
	SHLD	BUFPTR
	RET
;
OPNFCB:
	XRA	A
	STA	MYFCB+EXT
	STA	FILREC
	LXI	H,1380H ;LENGTH OF BUFFER
	SHLD	BUFLEN
	SHLD	BUFPTR
	MVI	C,0FH
	LXI	D,MYFCB
	CALL	5
	INR	A
	JNZ	OPENOK
	MVI	C,9
	LXI	D,NOFEMS
	CALL	5
	JMP	0
;
NOFEMS: DB	CR,LF,'NO SOURCE FILE$'
;
OPENOK:
	CALL	RDFILE
	JNZ	L0E84
	MVI	A,1
	STA	FILFLG
	JMP	L0EF4
;
L0E84:
	MVI	C,80H
	LXI	H,L1448
L0E89:
	MOV	M,A
	INX	H
	SHLD	L12AE
	DCR	C
	JZ	L0EF4
	MOV	A,C
	STA	L12B2
	CALL	RDFILE
	JNZ	OKRD
	PRINT	'**** BUG 2 IN PROGRAM CONTACT SOFTWARE TOOLS ****$'
	MVI	A,1
	STA	FILFLG
	STA	ERRSFL
	RET
;
OKRD:
	STA	L12B3
	LDA	L12B2
	MOV	C,A
	LHLD	L12AE
	LDA	L12B3
	JMP	L0E89
;
L0EF4:
	LDA	L151F
	SUI	1
	JNZ	BLOKCK
	LDA	FILFLG
	CPI	0
	JZ	L0F2E
	LDA	L12A9
	SUI	0
	JNZ	L0F1D
	LXI	H,L12B5
	LXI	D,STSTOR
	LXI	B,L12AC
	MVI	A,1
	CALL	L050E
	JMP	L0F55
;
L0F1D:
	LXI	H,L12B5
	LXI	D,STSTOR
	LXI	B,L12AD
	MVI	A,1
	CALL	L050E
	JMP	L0F55
;
L0F2E:
	LDA	L12A9
	SUI	0
	JNZ	L0F47
	LXI	H,L12B5
	LXI	D,STSTOR
	LXI	B,L12AC
	MVI	A,0
	CALL	L050E
	JMP	L0F55
;
L0F47:
	LXI	H,L12B5
	LXI	D,STSTOR
	LXI	B,L12AD
	MVI	A,0
	CALL	L050E
L0F55:
	LDA	STSTOR
	CPI	0
	JZ	L1009
L0F5D:
	LDA	L1520
	SUI	1
	JNZ	L1006
	LXI	H,STSTOR
	CALL	ERRCHK
	LDA	ERRCNT
	INR	A
	STA	ERRCNT
	LDA	ERRCNT
	SUI	0C8H
	JC	RETRY
	JZ	RETRY
	APRINT	'**** PERMANENT TRANSMISSION ERROR - PROGRAM ABORTING ****$'
	MVI	A,1
	STA	FILFLG
	STA	ERRSFL
	MVI	A,0
	STA	L151F
	STA	L1520
RETRY:
	LXI	H,L1380
	LXI	D,L1519
	MVI	A,2
	CALL	L098C
	LDA	L1519
	SUI	0
	JZ	L0FFE
	LXI	H,L1519
	CALL	ERRCHK
	LXI	H,L1523
	LXI	D,STSTOR
	LXI	B,L12B4
	MVI	A,0
	CALL	L050E
	JMP	L1003
;
L0FFE:
	MVI	A,0
	STA	L1520
L1003:
	JMP	L0F5D
;
L1006:
	JMP	L11E5
;
L1009:
	LDA	L1520
	SUI	1
	JNZ	L11E5
	LXI	H,L1380
	LXI	D,L1519
	MVI	A,2
	CALL	L098C
	LDA	L1519
	SUI	0
	JZ	L10B7
	LDA	FILFLG
	SUI	0
	JZ	L1034
	LDA	L1519
	SUI	4
	JZ	L10C7
L1034:
	LXI	H,L1519
	CALL	ERRCHK
	LDA	ERRCNT
	INR	A
	STA	ERRCNT
	LDA	ERRCNT
	SUI	0C8H
	JC	RETRY2
	JZ	RETRY2
	APRINT	'**** PERMANENT TRANSMISSION ERROR - PROGRAM ABORTING ****$'
	MVI	A,1
	STA	FILFLG
	STA	ERRSFL
	MVI	A,0
	STA	L151F
	STA	L1520
	JMP	L10B4
;
RETRY2:
	LXI	H,L1523
	LXI	D,STSTOR
	LXI	B,L12B4
	MVI	A,0
	CALL	L050E
L10B4:
	JMP	RETRY3
;
L10B7:
	LDA	L1380
	CPI	10H
	JNZ	L10E9
	LDA	SYNCB
	CPI	6
	JNZ	L10E9
L10C7:
	LDA	L12B7
	INR	A
	STA	L12B7
	LXI	H,L1448
	LXI	D,L12B8
	MVI	C,80H
L10D6:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	L10D6
	MVI	A,0
	STA	L151F
	STA	L1520
	JMP	RETRY3
;
L10E9:
	LDA	SYNCB
	CPI	5
	JNZ	SYNCOK
	PRINT	'**** SYNCHRONIZATION ERROR ****$'
	PRINT	'**** WILL ATTEMPT TO RE-TRANSMIT FILE ****$'
	XRA	A
	STA	ERRHIT
	INR	A
	STA	ERRSFL
	INR	A
	STA	FILFLG
	LHLD	NAMPTR
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	SHLD	NAMPTR
	JMP	L11DA
SYNCOK:
	MVI	A,0
	STA	L1520
	LDA	ERRCNT
	INR	A
	STA	ERRCNT
	LDA	ERRCNT
	SUI	0C8H
	JC	RETRY3
	JZ	RETRY3
	PRINT	'**** PERMANENT TRANSMISSION ERROR - PROGRAM ABORTING ****$'
	MVI	A,1
	STA	FILFLG
	STA	ERRSFL
L11DA:
	MVI	A,0
	STA	L151F
	STA	L1520
RETRY3:
	JMP	L1009
;
L11E5:
	MVI	A,1
	STA	L1520
	JMP	L0EF4
BLOKCK:
	LDA	ERRSFL
	SUI	1
	JZ	BKBACK
	PRINT	'**** BLOCK TRANSMITTED CORRECTLY ****$'
	XRA	A
	STA	ERRHIT	;Reset error count
	INR	A
	STA	L12A9
BKBACK:
	RET
;
CLNUP:
	LDA	ERRSFL
	CPI	0
	JNZ	CLBACK
	PRINT	'---- FILE HAS BEEN COMPLETELY TRANSMITTED ----$'
	PRINT	'**** DISCONNECTING FROM REMOTE CPU ****$'
CLBACK:
	RET
;
L12A8:	DB	0
L12A9:	DB	0
FILFLG: DB	0
ERRCNT: DB	0
L12AC:	DB	0EH
L12AD:	DB	83H
L12AE:	DB	0,0
NAMPTR: DB	0,0
L12B2:	DB	0
L12B3:	DB	0
L12B4:	DB	2
L12B5:	DB	10H,2
L12B7:	DB	0
L12B8:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0
L1380:	DB	0
SYNCB:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0
L1448:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0
L1510:	DB	0
L1511:	DB	10H,5
STSTOR: DB	0,0,0,0,0,0
L1519:	DB	0,0,0,0,0,0
L151F:	DB	0
L1520:	DB	0
ERRSFL: DB	0
L1522:	DB	0
L1523:	DB	10H,15H
DROPOUT:
	DB	0	;Carrier dropout count
ERRHIT:	DB	0	;Error count	
BUFFER: DB	0
;
	REPT	256	;GET 2K OF ZEROES
	DW	0,0,0,0,0,0,0,0
	ENDM
;
L1B25	EQU	BUFFER+600H
L2A0A	EQU	BUFFER + (2A0AH-1525H)
;
	END
